/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: HandlerLayer.cpp                                                   *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              05/04/2007       1.1                              *
* Carlos Grossy              17/05/2007       1.2                              *
*******************************************************************************/

#include "HandlerLayer.h"

handlerLayer::handlerLayer() {

    l = log::instance();
    hp = new handlerPackage();
    hm = new handlerMap();
    dl = new descriptorLayer();

    int *boards, cant;
    boards = dl->getU4ABoards(cant);
    for (int i = 0 ; i < cant ; i++) {
        hm->add(buildDeviceId(boards[i], U4AHND), U4ADSC, U4ADSC);
    };
    delete [] boards;
}

handlerLayer::~handlerLayer() {

    l->printLog("handlerLayer Destructor",true,true);
    l = NULL;
    delete hp;
    delete hm;
    delete dl;
}

bool handlerLayer::send(int id, char *d, int len, int timeout) {

    hndPackage *hpack;
    int dsc, nlen, hnd, board;
    char *msg;
    bool ok = false;

    board = unBuildBoardPart(id);
    hnd = unBuildDscPart(id);

    hpack = new hndPackage();
    hpack->h = hnd;
    hpack->oper = SEND;
    hpack->d = d;
    msg = hp->buildPackage(hpack, len, nlen);
    delete hpack;

    dsc = hm->getDescriptorSend(id);
    if (dsc == HNDERROR) {
        l->printLog("Error al pedir el descriptor de send del handler",true,true);
        delete [] msg;
        return ok;
    }
    else {
        ok = dl->send(board, dsc, msg, nlen, timeout);
        delete [] msg;
        return ok;
    };
}

char * handlerLayer::receive(int id, bool& ok, int& len, int timeout) {

    char *msg, *res;
    int dsc, nlen, board;

    dsc = hm->getDescriptorRecv(id);
    if (dsc == HNDERROR) {
        res = NULL;
        ok = false;
        return res;
    }
    else {
        board = unBuildBoardPart(id);
        msg = dl->receive(board, dsc, nlen, ok, timeout);
        if (ok) {
            hndPackage *hpack = hp->unbuildPackage(msg, nlen);
            len = nlen-3;
            res = new char[len];
            memcpy(res, hpack->d, len);
            delete hpack;
            delete msg;
        }
        else {
            len = nlen;
            res = NULL;
        };
        return res;
    };
}

void handlerLayer::addEntry(int id, int in, int out) {

    hm->add(id, in, out);
}

void handlerLayer::removeEntry(int id) {

    int dsc, board;

    board = unBuildBoardPart(id);
    dsc = hm->getDescriptorRecv(id);
    dl->freeDscIn(board, dsc);
    dsc = hm->getDescriptorSend(id);
    dl->freeDscOut(board, dsc);
    hm->remove(id);
}

bool handlerLayer::existsEntry(int id) {

    return (hm->exists(id));
}

int handlerLayer::requestDscIn(int serial, usbin dscin) {

    return (dl->requestDscIn(serial, dscin));
}

int handlerLayer::requestDscOut(int board, usbout dscout) {

    return (dl->requestDscOut(board, dscout));
}

int handlerLayer::buildDeviceId(int serial, int dsc) { //Ok

    int board = dl->getBoard(serial);
    return ((board*100) + dsc);
}

int handlerLayer::unBuildBoardPart(int id) { //Ok

    return ((int)(id / 100));
}

int handlerLayer::unBuildSerialPart(int id) { //Ok

    int board = unBuildBoardPart(id);
    return (dl->getSerial(board));

};

int handlerLayer::unBuildDscPart(int id) { //Ok

    return ((int) (id%100));
}

int * handlerLayer::getU4ABoards(int &cant) {

    return (dl->getU4ABoards(cant));
}
